"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.StockConfigService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const typeorm_2 = require("typeorm");
const stock_config_entity_1 = require("./entities/stock_config.entity");
const page_entity_1 = require("../pages/entities/page.entity");
const product_entity_1 = require("../products/entities/product.entity");
const material_entity_1 = require("../materials/entities/material.entity");
let StockConfigService = class StockConfigService {
    constructor(stockConfigRepository, productRepository, materialRepository, pageRepository) {
        this.stockConfigRepository = stockConfigRepository;
        this.productRepository = productRepository;
        this.materialRepository = materialRepository;
        this.pageRepository = pageRepository;
    }
    async create(createStockConfigDto) {
        const { PageID, priorityLevel, itemID, itemType, ...rest } = createStockConfigDto;
        if (!['PRODUCT', 'MATERIAL'].includes(itemType)) {
            throw new common_1.BadRequestException('itemType must be PRODUCT or MATERIAL');
        }
        const page = await this.pageRepository.findOne({
            where: { PageID },
            relations: ['stockConfigs'],
        });
        if (!page)
            throw new common_1.NotFoundException(`Page with ID ${PageID} not found`);
        const existing = page.stockConfigs.find((c) => c.itemID === itemID && c.itemType === itemType);
        const isUpdate = !!existing;
        const configToSave = this.stockConfigRepository.create({
            ...(isUpdate ? existing : {}),
            itemID,
            itemType,
            page,
            status: rest.status ?? (isUpdate ? existing.status : 'active'),
            targetStockLevel: rest.targetStockLevel ?? (isUpdate ? existing.targetStockLevel : 0),
            priorityLevel: priorityLevel ??
                (isUpdate ? existing.priorityLevel : page.stockConfigs.length + 1),
        });
        const saved = await this.stockConfigRepository.save(configToSave);
        await this.reorderPrioritiesInPage(PageID);
        const final = await this.stockConfigRepository.findOne({
            where: { StockConfigID: saved.StockConfigID },
            relations: ['page'],
        });
        return {
            message: isUpdate ? 'Updated existing config' : 'Created new config',
            stockConfig: {
                StockConfigID: final.StockConfigID,
                itemID: final.itemID,
                itemType: final.itemType,
                priorityLevel: final.priorityLevel,
                targetStockLevel: final.targetStockLevel,
                status: final.status,
                lastUpdated: final.lastUpdated,
                page: {
                    PageID: final.page.PageID,
                    createdAt: final.page.createdAt,
                    updatedAt: final.page.updatedAt,
                },
            },
        };
    }
    async reorderPrioritiesInPage(pageID) {
        const page = await this.pageRepository.findOne({
            where: { PageID: pageID },
            relations: ['stockConfigs'],
        });
        if (!page)
            throw new common_1.NotFoundException(`Page ${pageID} not found`);
        const sorted = [...page.stockConfigs].sort((a, b) => a.priorityLevel - b.priorityLevel);
        for (let i = 0; i < sorted.length; i++) {
            sorted[i].priorityLevel = i + 1;
        }
        await this.stockConfigRepository.save(sorted);
    }
    async findAll(pageId) {
        const whereCondition = pageId ? { page: { PageID: pageId } } : {};
        const stockConfigs = await this.stockConfigRepository.find({
            where: whereCondition,
            relations: ['page'],
            order: {
                page: { PageID: 'ASC' },
                priorityLevel: 'ASC',
            },
        });
        return await Promise.all(stockConfigs.map(async (config) => {
            let itemName = 'Unknown';
            let itemDetail = null;
            if (config.itemType === 'PRODUCT') {
                const product = await this.productRepository.findOne({
                    where: { ProductID: config.itemID },
                });
                if (product) {
                    itemName = `${product.brand} ${product.size}`;
                    itemDetail = product;
                }
            }
            else if (config.itemType === 'MATERIAL') {
                const material = await this.materialRepository.findOne({
                    where: { MaterialID: config.itemID },
                });
                if (material) {
                    itemName = `${material.name} ${material.size ?? ''}`.trim();
                    itemDetail = material;
                }
            }
            return {
                ...config,
                itemName,
                itemDetail,
            };
        }));
    }
    async findOne(id) {
        const config = await this.stockConfigRepository.findOne({
            where: { StockConfigID: id },
            relations: ['page'],
        });
        if (!config) {
            throw new common_1.NotFoundException(`StockConfig with ID ${id} not found`);
        }
        let itemName = 'Unknown';
        let itemDetail = null;
        if (config.itemType === 'PRODUCT') {
            const product = await this.productRepository.findOne({
                where: { ProductID: config.itemID },
            });
            if (product) {
                itemName = `${product.brand} ${product.size}`;
                itemDetail = product;
            }
        }
        else if (config.itemType === 'MATERIAL') {
            const material = await this.materialRepository.findOne({
                where: { MaterialID: config.itemID },
            });
            if (material) {
                itemName = `${material.name} ${material.size ?? ''}`.trim();
                itemDetail = material;
            }
        }
        return {
            ...config,
            itemName,
            itemDetail,
        };
    }
    async update(id, updateStockConfigDto) {
        const existingConfig = await this.stockConfigRepository.findOne({
            where: { StockConfigID: id },
        });
        if (!existingConfig) {
            throw new common_1.NotFoundException(`StockConfig with ID ${id} not found`);
        }
        const updatedConfig = {
            ...existingConfig,
            ...updateStockConfigDto,
        };
        return await this.stockConfigRepository.save(updatedConfig);
    }
    async updateMany(data) {
        const updatedConfigs = [];
        const pageIDsToReorder = new Set();
        for (const pageGroup of data.pages) {
            const { PageID, configs } = pageGroup;
            for (const entry of configs) {
                const config = await this.stockConfigRepository.findOne({
                    where: { StockConfigID: entry.id },
                    relations: ['page'],
                });
                if (!config) {
                    throw new common_1.NotFoundException(`StockConfig with ID ${entry.id} not found`);
                }
                if (config.page.PageID !== PageID) {
                    throw new common_1.BadRequestException(`StockConfig ID ${entry.id} is not in Page ${PageID}`);
                }
                const updated = {
                    ...config,
                    ...entry,
                };
                updatedConfigs.push(updated);
                pageIDsToReorder.add(PageID);
            }
        }
        const result = await this.stockConfigRepository.save(updatedConfigs);
        for (const pageID of pageIDsToReorder) {
            await this.reorderPrioritiesInPage(pageID);
        }
        return {
            message: `Updated ${result.length} stock configs in ${pageIDsToReorder.size} page(s)`,
            updated: result.map((r) => ({
                id: r.StockConfigID,
                pageID: r.page.PageID,
                priorityLevel: r.priorityLevel,
                status: r.status,
                targetStockLevel: r.targetStockLevel,
            })),
        };
    }
    async remove(id) {
        const existingConfig = await this.stockConfigRepository.findOne({
            where: { StockConfigID: id },
            relations: ['page'],
        });
        if (!existingConfig) {
            throw new common_1.NotFoundException(`StockConfig with ID ${id} not found`);
        }
        const pageID = existingConfig.page.PageID;
        await this.stockConfigRepository.delete(id);
        await this.reorderPrioritiesInPage(pageID);
        return {
            message: `StockConfig with ID ${id} deleted and priorities reordered`,
        };
    }
};
exports.StockConfigService = StockConfigService;
exports.StockConfigService = StockConfigService = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, typeorm_1.InjectRepository)(stock_config_entity_1.StockConfig)),
    __param(1, (0, typeorm_1.InjectRepository)(product_entity_1.Product)),
    __param(2, (0, typeorm_1.InjectRepository)(material_entity_1.Material)),
    __param(3, (0, typeorm_1.InjectRepository)(page_entity_1.Page)),
    __metadata("design:paramtypes", [typeorm_2.Repository,
        typeorm_2.Repository,
        typeorm_2.Repository,
        typeorm_2.Repository])
], StockConfigService);
//# sourceMappingURL=stock_configs.service.js.map