import { Repository } from 'typeorm';
import { CreateMaterialStockDto } from './dto/create-material_stock.dto';
import { UpdateMaterialStockDto } from './dto/update-material_stock.dto';
import { MaterialStock } from './entities/material_stock.entity';
import { Material } from '@/materials/entities/material.entity';
import { MaterialRestockOrder } from '@/material_restock_order/entities/material_restock_order.entity';
export declare class MaterialStocksService {
    private readonly materialStockRepo;
    private readonly materialRepo;
    private readonly restockOrderRepo;
    constructor(materialStockRepo: Repository<MaterialStock>, materialRepo: Repository<Material>, restockOrderRepo: Repository<MaterialRestockOrder>);
    create(createDto: CreateMaterialStockDto): Promise<MaterialStock>;
    findAll(): Promise<MaterialStock[]>;
    findOne(id: number): Promise<MaterialStock>;
    update(id: number, updateDto: UpdateMaterialStockDto): Promise<MaterialStock & UpdateMaterialStockDto>;
    remove(id: number): Promise<{
        message: string;
    }>;
}
