import { Repository } from 'typeorm';
import { Material } from './entities/material.entity';
import { MaterialStock } from '@/material_stocks/entities/material_stock.entity';
import { CreateMaterialDto } from './dto/create-material.dto';
import { UpdateMaterialDto } from './dto/update-material.dto';
export declare class MaterialsService {
    private readonly materialRepository;
    private readonly materialStockRepository;
    constructor(materialRepository: Repository<Material>, materialStockRepository: Repository<MaterialStock>);
    create(createMaterialDto: CreateMaterialDto): Promise<Material>;
    findAll(): Promise<Material[]>;
    findOne(id: number): Promise<Material>;
    update(id: number, updateMaterialDto: UpdateMaterialDto): Promise<Material>;
    remove(id: number): Promise<import("typeorm").DeleteResult>;
}
