"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
var OrderpioritiesService_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.OrderpioritiesService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const typeorm_2 = require("typeorm");
const orderpiority_entity_1 = require("./entities/orderpiority.entity");
const page_entity_1 = require("../pages/entities/page.entity");
const order_entity_1 = require("../orders/entities/order.entity");
let OrderpioritiesService = OrderpioritiesService_1 = class OrderpioritiesService {
    constructor(orderpiorityRepository, pageRepository, orderRepository) {
        this.orderpiorityRepository = orderpiorityRepository;
        this.pageRepository = pageRepository;
        this.orderRepository = orderRepository;
        this.logger = new common_1.Logger(OrderpioritiesService_1.name);
    }
    async createOrUpdate(createDto) {
        const { orderID, pageID, priority } = createDto;
        this.logger.log(`📥 createOrUpdate: orderID=${orderID}, pageID=${pageID}, priority=${priority}`);
        const page = await this.pageRepository.findOne({
            where: { PageID: pageID },
            relations: ['orderPriorities', 'orderPriorities.order'],
        });
        if (!page) {
            this.logger.warn(`❌ Page with ID ${pageID} not found`);
            throw new common_1.NotFoundException(`Page with ID ${pageID} not found`);
        }
        const order = await this.orderRepository.findOne({
            where: { OrderID: orderID },
        });
        if (!order) {
            this.logger.warn(`❌ Order with ID ${orderID} not found`);
            throw new common_1.NotFoundException(`Order with ID ${orderID} not found`);
        }
        const existing = page.orderPriorities?.find((op) => op.order?.OrderID === orderID);
        if (existing) {
            this.logger.log(`✏️ Updating existing OrderPriority ID=${existing.orderPriorityID}`);
            existing.priority = priority !== undefined ? priority : existing.priority;
        }
        else {
            this.logger.log(`➕ Creating new OrderPriority for orderID=${orderID} and pageID=${pageID}`);
        }
        const saved = await this.orderpiorityRepository.save(existing ??
            this.orderpiorityRepository.create({
                order,
                page,
                priority: priority !== undefined ? priority : page.orderPriorities.length + 1,
            }));
        await this.reorderPrioritiesInPage(pageID);
        this.logger.log(`🔁 Reordered priorities in Page ${pageID}`);
        const final = await this.orderpiorityRepository.findOne({
            where: { orderPriorityID: saved.orderPriorityID },
            relations: ['order', 'page'],
        });
        this.logger.log(`✅ Final OrderPriority saved: ID=${final.orderPriorityID}`);
        return {
            message: existing
                ? 'Updated existing order priority'
                : 'Created new order priority',
            orderPriority: {
                orderPriorityID: final.orderPriorityID,
                priority: final.priority,
                order: { OrderID: final.order.OrderID },
                page: { PageID: final.page.PageID },
            },
        };
    }
    async updateMany(data) {
        const updatedRecords = [];
        const pageIDsToReorder = new Set();
        for (const pageGroup of data.pages) {
            const { pageID, configs } = pageGroup;
            for (const entry of configs) {
                const record = await this.orderpiorityRepository.findOne({
                    where: { orderPriorityID: entry.id },
                    relations: ['page'],
                });
                if (!record) {
                    throw new common_1.NotFoundException(`OrderPriority with ID ${entry.id} not found`);
                }
                if (record.page.PageID !== pageID) {
                    throw new common_1.BadRequestException(`OrderPriority ID ${entry.id} is not in Page ${pageID}`);
                }
                if (entry.priority !== undefined) {
                    record.priority = entry.priority;
                }
                updatedRecords.push(record);
                pageIDsToReorder.add(pageID);
            }
        }
        const result = await this.orderpiorityRepository.save(updatedRecords);
        for (const pid of pageIDsToReorder) {
            await this.reorderPrioritiesInPage(pid);
        }
        return {
            message: `Updated ${result.length} order priorities in ${pageIDsToReorder.size} page(s)`,
            updated: result.map((r) => ({
                id: r.orderPriorityID,
                pageID: r.page.PageID,
                priority: r.priority,
            })),
        };
    }
    async reorderPrioritiesInPage(pageID) {
        const page = await this.pageRepository.findOne({
            where: { PageID: pageID },
            relations: ['orderPriorities'],
        });
        if (!page)
            throw new common_1.NotFoundException(`Page with ID ${pageID} not found`);
        const sorted = [...page.orderPriorities].sort((a, b) => a.priority - b.priority);
        for (let i = 0; i < sorted.length; i++) {
            sorted[i].priority = i + 1;
        }
        await this.orderpiorityRepository.save(sorted);
    }
    async findAll() {
        const waitingOrders = await this.orderRepository.find({
            where: { status: 'WAITING' },
        });
        const pages = await this.pageRepository.find({
            relations: ['orderPriorities'],
        });
        const allPriorities = [];
        for (const page of pages) {
            for (const order of waitingOrders) {
                const alreadyExists = page.orderPriorities?.some((op) => op.order?.OrderID === order.OrderID);
                if (!alreadyExists) {
                    const newPriority = this.orderpiorityRepository.create({
                        order,
                        page,
                        priority: page.orderPriorities.length + 1,
                    });
                    const saved = await this.orderpiorityRepository.save(newPriority);
                    page.orderPriorities.push(saved);
                    allPriorities.push(saved);
                }
            }
        }
        const result = await this.orderpiorityRepository.find({
            relations: ['order', 'page'],
        });
        return result;
    }
    async findWithOptionalFilters(orderId, pageId) {
        const query = this.orderpiorityRepository
            .createQueryBuilder('orderPriority')
            .leftJoinAndSelect('orderPriority.order', 'order')
            .leftJoinAndSelect('orderPriority.page', 'page')
            .where('order.status IN (:...statuses)', {
            statuses: ['กำลังรอ', 'กำลังผลิต'],
        });
        if (orderId !== undefined) {
            query.andWhere('order.OrderID = :orderId', { orderId });
        }
        if (pageId !== undefined) {
            query.andWhere('page.PageID = :pageId', { pageId });
        }
        return await query.getMany();
    }
    async findOne(id) {
        const orderPriority = await this.orderpiorityRepository.findOne({
            where: { orderPriorityID: id },
            relations: ['order', 'page'],
        });
        if (!orderPriority) {
            throw new common_1.NotFoundException(`OrderPriority with ID ${id} not found`);
        }
        return orderPriority;
    }
    async update(id, updateDto) {
        const orderPriority = await this.findOne(id);
        Object.assign(orderPriority, updateDto);
        return await this.orderpiorityRepository.save(orderPriority);
    }
    async remove(id) {
        const orderPriority = await this.findOne(id);
        return await this.orderpiorityRepository.remove(orderPriority);
    }
};
exports.OrderpioritiesService = OrderpioritiesService;
exports.OrderpioritiesService = OrderpioritiesService = OrderpioritiesService_1 = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, typeorm_1.InjectRepository)(orderpiority_entity_1.OrderPriority)),
    __param(1, (0, typeorm_1.InjectRepository)(page_entity_1.Page)),
    __param(2, (0, typeorm_1.InjectRepository)(order_entity_1.Order)),
    __metadata("design:paramtypes", [typeorm_2.Repository,
        typeorm_2.Repository,
        typeorm_2.Repository])
], OrderpioritiesService);
//# sourceMappingURL=orderpiorities.service.js.map