import { Repository, Connection } from 'typeorm';
import { Order } from './entities/order.entity';
import { CreateOrderDto } from './dto/create-order.dto';
import { UpdateOrderDto } from './dto/update-order.dto';
import { Product } from '@/products/entities/product.entity';
import { OrderPriority } from '@/orderpiorities/entities/orderpiority.entity';
import { Page } from '@/pages/entities/page.entity';
import { OrderDetail } from '@/order_details/entities/order_detail.entity';
export declare class OrdersService {
    private readonly orderRepository;
    private readonly productRepository;
    private readonly orderpiorityRepository;
    private readonly pageRepository;
    private readonly orderDetailRepository;
    private readonly connection;
    private readonly logger;
    constructor(orderRepository: Repository<Order>, productRepository: Repository<Product>, orderpiorityRepository: Repository<OrderPriority>, pageRepository: Repository<Page>, orderDetailRepository: Repository<OrderDetail>, connection: Connection);
    create(createOrderDto: CreateOrderDto): Promise<Order>;
    upsertMany(ordersDto: CreateOrderDto[]): Promise<Order[]>;
    findAll(): Promise<Order[]>;
    findOne(id: number): Promise<Order>;
    update(id: number, updateOrderDto: UpdateOrderDto): Promise<Order>;
    remove(id: number): Promise<Order>;
}
