import { Repository } from 'typeorm';
import { ProductStock } from './entities/product_stock.entity';
import { Product } from '@/products/entities/product.entity';
import { CreateProductStockDto } from './dto/create-product_stock.dto';
import { UpdateProductStockDto } from './dto/update-product_stock.dto';
export declare class ProductStocksService {
    private readonly productStockRepository;
    private readonly productRepository;
    constructor(productStockRepository: Repository<ProductStock>, productRepository: Repository<Product>);
    create(createProductStockDto: CreateProductStockDto): Promise<ProductStock>;
    findAll(): Promise<ProductStock[]>;
    findOne(id: number): Promise<ProductStock>;
    update(id: number, updateProductStockDto: UpdateProductStockDto): Promise<ProductStock>;
    remove(id: number): Promise<ProductStock>;
}
