"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ProductStocksService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const typeorm_2 = require("typeorm");
const product_stock_entity_1 = require("./entities/product_stock.entity");
const product_entity_1 = require("../products/entities/product.entity");
let ProductStocksService = class ProductStocksService {
    constructor(productStockRepository, productRepository) {
        this.productStockRepository = productStockRepository;
        this.productRepository = productRepository;
    }
    async create(createProductStockDto) {
        const { ProductID, quantityReceived, status, addDate } = createProductStockDto;
        const product = await this.productRepository.findOne({
            where: { ProductID },
        });
        if (!product) {
            throw new common_1.NotFoundException(`Product with ID ${ProductID} not found`);
        }
        const newProductStock = this.productStockRepository.create({
            product,
            quantityReceived,
            status,
            addDate: addDate || new Date(),
        });
        return await this.productStockRepository.save(newProductStock);
    }
    async findAll() {
        return this.productStockRepository.find({
            relations: ['product'],
        });
    }
    async findOne(id) {
        const productStock = await this.productStockRepository.findOne({
            where: { productStockID: id },
            relations: ['product'],
        });
        if (!productStock) {
            throw new common_1.NotFoundException(`ProductStock with ID ${id} not found`);
        }
        return productStock;
    }
    async update(id, updateProductStockDto) {
        const { quantityReceived, status, addDate } = updateProductStockDto;
        const productStock = await this.findOne(id);
        productStock.quantityReceived =
            quantityReceived ?? productStock.quantityReceived;
        productStock.status = status ?? productStock.status;
        productStock.addDate = addDate ?? productStock.addDate;
        return this.productStockRepository.save(productStock);
    }
    async remove(id) {
        const productStock = await this.findOne(id);
        await this.productStockRepository.remove(productStock);
        return productStock;
    }
};
exports.ProductStocksService = ProductStocksService;
exports.ProductStocksService = ProductStocksService = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, typeorm_1.InjectRepository)(product_stock_entity_1.ProductStock)),
    __param(1, (0, typeorm_1.InjectRepository)(product_entity_1.Product)),
    __metadata("design:paramtypes", [typeorm_2.Repository,
        typeorm_2.Repository])
], ProductStocksService);
//# sourceMappingURL=product_stocks.service.js.map