"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.CreateManyProductionTargetsDto = exports.CreateProductionTargetDto = exports.parseDate = void 0;
const common_1 = require("@nestjs/common");
const class_transformer_1 = require("class-transformer");
const class_validator_1 = require("class-validator");
function parseDate(dateInput) {
    if (typeof dateInput === 'string') {
        const ddMmYyyyRegex = /^(\d{1,2})\/(\d{1,2})\/(\d{4})$/;
        const match = dateInput.match(ddMmYyyyRegex);
        if (match) {
            const [, day, month, year] = match.map(Number);
            return new Date(year, month - 1, day);
        }
        const parsedDate = new Date(dateInput);
        if (!isNaN(parsedDate.getTime())) {
            return parsedDate;
        }
        throw new common_1.BadRequestException(`❌ Invalid date format: ${dateInput}. Expected "YYYY-MM-DD" or "dd/MM/yyyy".`);
    }
    else if (typeof dateInput === 'number') {
        return new Date(dateInput);
    }
    throw new common_1.BadRequestException(`❌ Unsupported date format: ${dateInput}`);
}
exports.parseDate = parseDate;
class CreateProductionTargetDto {
    constructor() {
        this.Status = 'กำลังรอ';
    }
}
exports.CreateProductionTargetDto = CreateProductionTargetDto;
__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsInt)(),
    __metadata("design:type", Number)
], CreateProductionTargetDto.prototype, "ProductionTargetID", void 0);
__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsInt)(),
    __metadata("design:type", Number)
], CreateProductionTargetDto.prototype, "OrderID", void 0);
__decorate([
    (0, class_validator_1.IsInt)(),
    __metadata("design:type", Number)
], CreateProductionTargetDto.prototype, "itemID", void 0);
__decorate([
    (0, class_validator_1.IsEnum)(['PRODUCT', 'MATERIAL']),
    __metadata("design:type", String)
], CreateProductionTargetDto.prototype, "itemType", void 0);
__decorate([
    (0, class_validator_1.IsInt)(),
    (0, class_validator_1.Min)(0),
    __metadata("design:type", Number)
], CreateProductionTargetDto.prototype, "TargetProduced", void 0);
__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsInt)(),
    (0, class_validator_1.Min)(0),
    __metadata("design:type", Number)
], CreateProductionTargetDto.prototype, "ActualProduced", void 0);
__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsString)(),
    __metadata("design:type", String)
], CreateProductionTargetDto.prototype, "Status", void 0);
__decorate([
    (0, class_transformer_1.Transform)(({ value }) => parseDate(value), { toClassOnly: true }),
    (0, class_validator_1.IsDate)(),
    (0, class_validator_1.IsOptional)(),
    __metadata("design:type", Date)
], CreateProductionTargetDto.prototype, "Date", void 0);
__decorate([
    (0, class_transformer_1.Transform)(({ value }) => (value ? parseDate(value) : null), {
        toClassOnly: true,
    }),
    (0, class_validator_1.IsDate)(),
    (0, class_validator_1.IsOptional)(),
    __metadata("design:type", Date)
], CreateProductionTargetDto.prototype, "startTime", void 0);
__decorate([
    (0, class_transformer_1.Transform)(({ value }) => (value ? parseDate(value) : null), {
        toClassOnly: true,
    }),
    (0, class_validator_1.IsDate)(),
    (0, class_validator_1.IsOptional)(),
    __metadata("design:type", Date)
], CreateProductionTargetDto.prototype, "endTime", void 0);
class CreateManyProductionTargetsDto {
}
exports.CreateManyProductionTargetsDto = CreateManyProductionTargetsDto;
//# sourceMappingURL=create-production_target.dto.js.map