"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ProductionTarget = void 0;
const typeorm_1 = require("typeorm");
const order_entity_1 = require("../../orders/entities/order.entity");
const page_entity_1 = require("../../pages/entities/page.entity");
let ProductionTarget = class ProductionTarget {
};
exports.ProductionTarget = ProductionTarget;
__decorate([
    (0, typeorm_1.PrimaryGeneratedColumn)(),
    __metadata("design:type", Number)
], ProductionTarget.prototype, "ProductionTargetID", void 0);
__decorate([
    (0, typeorm_1.Column)(),
    __metadata("design:type", Number)
], ProductionTarget.prototype, "itemID", void 0);
__decorate([
    (0, typeorm_1.ManyToOne)(() => page_entity_1.Page, (page) => page.productionTargets, {
        onDelete: 'SET NULL',
        nullable: true,
    }),
    (0, typeorm_1.JoinColumn)({ name: 'PageID' }),
    __metadata("design:type", page_entity_1.Page)
], ProductionTarget.prototype, "page", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: 'enum', enum: ['PRODUCT', 'MATERIAL'] }),
    __metadata("design:type", String)
], ProductionTarget.prototype, "itemType", void 0);
__decorate([
    (0, typeorm_1.ManyToOne)(() => order_entity_1.Order, (order) => order.productionTargets, {
        onDelete: 'SET NULL',
        nullable: true,
    }),
    (0, typeorm_1.JoinColumn)({ name: 'OrderID' }),
    __metadata("design:type", order_entity_1.Order)
], ProductionTarget.prototype, "order", void 0);
__decorate([
    (0, typeorm_1.Column)(),
    __metadata("design:type", Number)
], ProductionTarget.prototype, "TargetProduced", void 0);
__decorate([
    (0, typeorm_1.Column)({ default: 0 }),
    __metadata("design:type", Number)
], ProductionTarget.prototype, "ActualProduced", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: 'timestamp', nullable: true }),
    __metadata("design:type", Date)
], ProductionTarget.prototype, "startTime", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: 'timestamp', nullable: true }),
    __metadata("design:type", Date)
], ProductionTarget.prototype, "endTime", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: 'float', nullable: true }),
    __metadata("design:type", Number)
], ProductionTarget.prototype, "totalProductionHours", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: 'varchar', length: 50, default: 'กำลังรอ' }),
    __metadata("design:type", String)
], ProductionTarget.prototype, "Status", void 0);
__decorate([
    (0, typeorm_1.CreateDateColumn)(),
    __metadata("design:type", Date)
], ProductionTarget.prototype, "Date", void 0);
__decorate([
    (0, typeorm_1.UpdateDateColumn)(),
    __metadata("design:type", Date)
], ProductionTarget.prototype, "updatedAt", void 0);
exports.ProductionTarget = ProductionTarget = __decorate([
    (0, typeorm_1.Entity)('Production_Target')
], ProductionTarget);
//# sourceMappingURL=production_target.entity.js.map