import { ProductionTargetsService } from './production_targets.service';
import { CreateProductionTargetDto, CreateManyProductionTargetsDto } from './dto/create-production_target.dto';
import { UpdateProductionTargetDto } from './dto/update-production_target.dto';
import { ProductionTarget } from './entities/production_target.entity';
export declare class ProductionTargetsController {
    private readonly productionTargetsService;
    private readonly logger;
    constructor(productionTargetsService: ProductionTargetsService);
    create(createProductionTargetDto: CreateProductionTargetDto): Promise<ProductionTarget>;
    createMany(createManyDto: CreateManyProductionTargetsDto): Promise<ProductionTarget[]>;
    findByDate(dateStr: string): Promise<ProductionTarget[]>;
    findAll(): Promise<ProductionTarget[]>;
    findOne(id: string): Promise<ProductionTarget>;
    update(id: string, updateProductionTargetDto: UpdateProductionTargetDto): Promise<ProductionTarget>;
    deleteProductionTargets(dateStr: string): Promise<{
        deletedCount: number;
    }>;
    remove(id: string): Promise<ProductionTarget>;
}
