import { Repository } from 'typeorm';
import { Product } from './entities/product.entity';
import { CreateProductDto } from './dto/create-product.dto';
import { UpdateProductDto } from './dto/update-product.dto';
import { ProductStock } from '@/product_stocks/entities/product_stock.entity';
export declare class ProductsService {
    private readonly productRepository;
    private readonly productStockRepository;
    constructor(productRepository: Repository<Product>, productStockRepository: Repository<ProductStock>);
    create(createProductDto: CreateProductDto): Promise<Product>;
    findAll(): Promise<Product[]>;
    findOne(id: number): Promise<Product>;
    update(productId: number, updateDto: UpdateProductDto): Promise<Product>;
    createOrUpdate(createProductDto: CreateProductDto): Promise<Product>;
    remove(id: number): Promise<void>;
}
