"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.QueueTypesService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const typeorm_2 = require("typeorm");
const queue_type_entity_1 = require("./entities/queue-type.entity");
let QueueTypesService = class QueueTypesService {
    constructor(queueTypeRepository) {
        this.queueTypeRepository = queueTypeRepository;
    }
    async create(createQueueTypeDto) {
        const newQueueType = this.queueTypeRepository.create(createQueueTypeDto);
        return await this.queueTypeRepository.save(newQueueType);
    }
    async findAll() {
        return await this.queueTypeRepository.find();
    }
    async findOne(id) {
        return await this.queueTypeRepository.findOne({
            where: { QueueTypeID: id },
        });
    }
    async update(id, updateQueueTypeDto) {
        await this.queueTypeRepository.update(id, updateQueueTypeDto);
        return this.findOne(id);
    }
    async remove(id) {
        const queueType = await this.queueTypeRepository.findOne({
            where: { QueueTypeID: id },
        });
        if (!queueType) {
            throw new common_1.NotFoundException(`QueueType with ID ${id} not found`);
        }
        await this.queueTypeRepository.remove(queueType);
        return queueType;
    }
};
exports.QueueTypesService = QueueTypesService;
exports.QueueTypesService = QueueTypesService = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, typeorm_1.InjectRepository)(queue_type_entity_1.QueueType)),
    __metadata("design:paramtypes", [typeorm_2.Repository])
], QueueTypesService);
//# sourceMappingURL=queue-types.service.js.map