import { StockConfigService } from './stock_configs.service';
import { BatchUpdateManyStockConfigDto, CreateStockConfigDto } from './dto/create-stock_config.dto';
import { UpdateStockConfigDto } from './dto/update-stock_config.dto';
export declare class StockConfigController {
    private readonly stockConfigService;
    constructor(stockConfigService: StockConfigService);
    create(createStockConfigDto: CreateStockConfigDto): Promise<{
        message: string;
        stockConfig: {
            StockConfigID: number;
            itemID: number;
            itemType: "PRODUCT" | "MATERIAL";
            priorityLevel: number;
            targetStockLevel: number;
            status: string;
            lastUpdated: Date;
            page: {
                PageID: number;
                createdAt: Date;
                updatedAt: Date;
            };
        };
    }>;
    findAll(pageId?: string): Promise<{
        itemName: string;
        itemDetail: any;
        StockConfigID: number;
        itemID: number;
        itemType: "PRODUCT" | "MATERIAL";
        page: import("../pages/entities/page.entity").Page;
        priorityLevel: number;
        targetStockLevel: number;
        status: string;
        lastUpdated: Date;
    }[]>;
    findOne(id: number): Promise<{
        itemName: string;
        itemDetail: any;
        StockConfigID: number;
        itemID: number;
        itemType: "PRODUCT" | "MATERIAL";
        page: import("../pages/entities/page.entity").Page;
        priorityLevel: number;
        targetStockLevel: number;
        status: string;
        lastUpdated: Date;
    }>;
    updateMany(body: BatchUpdateManyStockConfigDto): Promise<{
        message: string;
        updated: {
            id: any;
            pageID: any;
            priorityLevel: any;
            status: any;
            targetStockLevel: any;
        }[];
    }>;
    update(id: number, updateStockConfigDto: UpdateStockConfigDto): Promise<{
        itemID: number;
        itemType: "PRODUCT" | "MATERIAL";
        PageID?: number;
        priorityLevel: number;
        targetStockLevel: number;
        status: string;
        StockConfigID: number;
        page: import("../pages/entities/page.entity").Page;
        lastUpdated: Date;
    } & import("./entities/stock_config.entity").StockConfig>;
    remove(id: number): Promise<{
        message: string;
    }>;
}
