/* eslint-disable prettier/prettier */
import { Module } from '@nestjs/common';
import { TypeOrmModule } from '@nestjs/typeorm';
import { ServeStaticModule } from '@nestjs/serve-static';
import { join } from 'path';
import { DataSource } from 'typeorm';
import { AppController } from './app.controller';
import { AppService } from './app.service';

// Import Modules
import { UsersModule } from './users/users.module';
import { RolesModule } from './roles/roles.module';
import { AuthModule } from './auth/auth.module';
import { QueuesModule } from './queues/queues.module';
import { EmployeesModule } from './employees/employees.module';
import { MachinesModule } from './machines/machines.module';
import { PagesModule } from './pages/pages.module';
import { OrdersModule } from './orders/orders.module';
import { OrderPriorityModule } from './orderpiorities/orderpiorities.module';
import { MachineDetailsModule } from './machine_details/machine_details.module';
import { MaterialStocksModule } from './material_stocks/material_stocks.module';
import { ProductsModule } from './products/products.module';
import { OrderDetailsModule } from './order_details/order_details.module';
import { ProductStocksModule } from './product_stocks/product_stocks.module';
import { CustomersModule } from './customers/customers.module';
import { MaterialsModule } from './materials/materials.module';
import { MaterialRestockOrderModule } from './material_restock_order/material_restock_order.module';
import { StockConfigsModule } from './stock_configs/stock_configs.module';

// Import Entities
import { User } from './users/entities/user.entity';
import { Role } from './roles/entities/role.entity';
import { Queue } from './queues/entities/queue.entity';
import { Machine } from './machines/entities/machine.entity';
import { MachineDetail } from './machine_details/entities/machine_detail.entity';
import { Employee } from './employees/entities/employee.entity';
import { Customer } from './customers/entities/customer.entity';
import { Material } from './materials/entities/material.entity';
import { MaterialStock } from './material_stocks/entities/material_stock.entity';
import { MaterialRestockOrder } from './material_restock_order/entities/material_restock_order.entity';
import { OrderDetail } from './order_details/entities/order_detail.entity';
import { OrderPriority } from './orderpiorities/entities/orderpiority.entity';
import { Order } from './orders/entities/order.entity';
import { Page } from './pages/entities/page.entity';
import { ProductStock } from './product_stocks/entities/product_stock.entity';
import { Product } from './products/entities/product.entity';
import { RecipesModule } from './recipes/recipes.module';
import { RecipeIngredientsModule } from './recipe_ingredients/recipe_ingredients.module';
import { Recipe } from './recipes/entities/recipe.entity';
import { RecipeIngredient } from './recipe_ingredients/entities/recipe_ingredient.entity';
import { StockConfig } from './stock_configs/entities/stock_config.entity';
@Module({
  imports: [
    TypeOrmModule.forRoot({
      type: 'mysql',
      host: 'localhost',
      port: 3306,
      username: 'root',
      password: '',
      database: 'water',
      entities: [
        User,
        Role,
        Queue,
        Machine,
        MachineDetail,
        Employee,
        Customer,
        Material,
        MaterialStock,
        MaterialRestockOrder,
        OrderDetail,
        OrderPriority,
        Order,
        Page,
        ProductStock,
        Product,
        Recipe,
        RecipeIngredient,
        StockConfig,
      ],
      synchronize: true,
    }),
    ServeStaticModule.forRoot({
      rootPath: join(__dirname, '..', 'public'),
    }),
    UsersModule,
    RolesModule,
    AuthModule,
    QueuesModule,
    EmployeesModule,
    MachinesModule,
    PagesModule,
    OrdersModule,
    OrderPriorityModule,
    MachineDetailsModule,
    MaterialStocksModule,
    ProductsModule,
    OrderDetailsModule,
    ProductStocksModule,
    CustomersModule,
    MaterialsModule,
    MaterialRestockOrderModule,
    RecipesModule,
    RecipeIngredientsModule,
    StockConfigsModule,
  ],
  controllers: [AppController],
  providers: [AppService],
})
export class AppModule {
  constructor(private dataSource: DataSource) {}
}
