import { Entity, PrimaryGeneratedColumn, Column, OneToMany } from 'typeorm';
import { Order } from '@/orders/entities/order.entity';
@Entity('Customer')
export class Customer {
  @PrimaryGeneratedColumn()
  CustomerID: number;

  @Column({ default: '' })
  name: string;

  @Column({ default: '' })
  phoneNumber: string;

  @Column({ default: '' })
  address: string;

  @OneToMany(() => Order, (order) => order.customer)
  orders: Order[];
}
