import { Entity, PrimaryGeneratedColumn, Column, ManyToMany } from 'typeorm';
import { Queue } from '@/queues/entities/queue.entity';

@Entity('Employee')
export class Employee {
  @PrimaryGeneratedColumn()
  EmployeeID: number;

  @Column({ type: 'varchar', length: 255 })
  name: string;

  @Column({ type: 'varchar', length: 10 })
  gender: string;

  @Column({ type: 'int' })
  age: number;

  @Column({ type: 'varchar', length: 100 })
  mainRole: string;

  @Column({ type: 'varchar', length: 100, nullable: true })
  secondRole: string;

  @Column({ type: 'varchar', length: 20 })
  tel: string;

  @Column({ type: 'int' })
  dailyWageRate: number;

  @Column({ type: 'date' })
  startDate: Date;

  @Column({ type: 'varchar', length: 255, nullable: true })
  image: string;

  @ManyToMany(() => Queue, (queue) => queue.employees)
  queues: Queue[];
}
