import {
  Entity,
  PrimaryGeneratedColumn,
  ManyToOne,
  Column,
  JoinColumn,
  OneToMany,
} from 'typeorm';
import { Machine } from '@/machines/entities/machine.entity';
import { Recipe } from '@/recipes/entities/recipe.entity';
@Entity('Machine_Detail')
export class MachineDetail {
  @PrimaryGeneratedColumn()
  MachineDetailID: number;

  @OneToMany(() => Recipe, (recipe) => recipe.machineDetail)
  recipes: Recipe[]; // ✅ เชื่อมกลับไปยัง Recipe (One MachineDetail มีหลาย Recipe)

  @ManyToOne(() => Machine, (machine) => machine.machineDetails, {
    onDelete: 'CASCADE',
  })
  @JoinColumn({ name: 'MachineID' })
  machine: Machine;

  @Column()
  outputRate: number;

  @Column({ type: 'float', nullable: true })
  changOver?: number;
}
