import {
  Controller,
  Get,
  Post,
  Body,
  Patch,
  Param,
  Delete,
} from '@nestjs/common';
import { MachineDetailsService } from './machine_details.service';
import { CreateMachineDetailDto } from './dto/create-machine_detail.dto';
import { UpdateMachineDetailDto } from './dto/update-machine_detail.dto';

@Controller('machine-details')
export class MachineDetailsController {
  constructor(private readonly machineDetailsService: MachineDetailsService) {}

  @Post()
  create(@Body() createMachineDetailDto: CreateMachineDetailDto) {
    return this.machineDetailsService.create(createMachineDetailDto);
  }

  @Get()
  findAll() {
    return this.machineDetailsService.findAll();
  }

  @Get(':id')
  findOne(@Param('id') id: string) {
    return this.machineDetailsService.findOne(+id);
  }

  @Patch(':id')
  update(
    @Param('id') id: string,
    @Body() updateMachineDetailDto: UpdateMachineDetailDto,
  ) {
    return this.machineDetailsService.update(+id, updateMachineDetailDto);
  }

  @Delete(':id')
  remove(@Param('id') id: string) {
    return this.machineDetailsService.remove(+id);
  }
}
