import { Entity, PrimaryGeneratedColumn, Column, OneToMany } from 'typeorm';
import { Queue } from '@/queues/entities/queue.entity';
import { MachineDetail } from '@/machine_details/entities/machine_detail.entity';
@Entity('Machine')
export class Machine {
  @PrimaryGeneratedColumn()
  MachineID: number;

  @OneToMany(() => MachineDetail, (machineDetail) => machineDetail.machine)
  machineDetails: MachineDetail[];

  @OneToMany(() => Queue, (queue) => queue.machine)
  queues: Queue[];

  @Column({ type: 'varchar', length: 100 })
  name: string;

  @Column({ type: 'varchar', length: 50 })
  type: string;

  @Column({ type: 'date', nullable: true })
  lastMaintenanceDate: Date;

  @Column({ type: 'enum', enum: ['ACTIVE', 'INACTIVE', 'MAINTENANCE'] })
  status: 'ACTIVE' | 'INACTIVE' | 'MAINTENANCE';

  @Column({ type: 'text', nullable: true })
  notes?: string;
}
