import { Injectable } from '@nestjs/common';
import { CreateMachineDto } from './dto/create-machine.dto';
import { UpdateMachineDto } from './dto/update-machine.dto';
import { InjectRepository } from '@nestjs/typeorm';
import { Repository } from 'typeorm';
import { Machine } from './entities/machine.entity';

@Injectable()
export class MachinesService {
  constructor(
    @InjectRepository(Machine)
    private readonly machineRepository: Repository<Machine>,
  ) {}

  create(createMachineDto: CreateMachineDto) {
    return 'This action adds a new machine';
  }

  async findAll() {
    return await this.machineRepository.find({
      relations: [
        'machineDetails',
        'machineDetails.recipes',
        'machineDetails.recipes.ingredients',
        'machineDetails.recipes.ingredients.material',
      ],
    });
  }

  findOne(id: number) {
    return `This action returns a #${id} machine`;
  }

  update(id: number, updateMachineDto: UpdateMachineDto) {
    return `This action updates a #${id} machine`;
  }

  remove(id: number) {
    return `This action removes a #${id} machine`;
  }
}
