import { NestFactory } from '@nestjs/core';
import { SwaggerModule, DocumentBuilder } from '@nestjs/swagger';
import { AppModule } from './app.module';
import { ValidationPipe } from '@nestjs/common';
import { exec } from 'child_process';

async function bootstrap() {
  const app = await NestFactory.create(AppModule);

  // 🔹 เพิ่ม Swagger API Documentation
  const config = new DocumentBuilder()
    .setTitle('Temperature example')
    .setDescription('The Temperature API description')
    .setVersion('1.0')
    .addTag('temperature')
    .build();
  const document = SwaggerModule.createDocument(app, config);
  SwaggerModule.setup('api', app, document);

  // 🔹 เพิ่ม Global Validation Pipe
  app.useGlobalPipes(new ValidationPipe());

  // 🔹 Enable CORS
  app.enableCors();

  // 🔹 Start FastAPI (Autoqueue.py) พร้อม NestJS
  exec(
    'uvicorn src.queues.AutoQueue.Autoqueue:app --host 127.0.0.1 --port 9000 --reload',
    (error, stdout, stderr) => {
      if (error) {
        console.error(`❌ Error starting FastAPI: ${error.message}`);
        return;
      }
      if (stderr) {
        console.error(`⚠️ FastAPI stderr: ${stderr}`);
        return;
      }
      console.log(`✅ FastAPI started successfully: ${stdout}`);
    },
  );
  // 🔹 Start NestJS
  await app.listen(4000);
  console.log('✅ NestJS is running on http://localhost:4000');
  console.log('✅ FastAPI started successfully: http://localhost:9000');
}

bootstrap();
