import {
  Entity,
  PrimaryGeneratedColumn,
  Column,
  OneToMany,
  JoinColumn,
} from 'typeorm';
import { MaterialStock } from '@/material_stocks/entities/material_stock.entity';

@Entity('Material_Restock_Order')
export class MaterialRestockOrder {
  @PrimaryGeneratedColumn()
  MaterialRestockOrderID: number;

  @Column({ type: 'date' })
  OrderDate: Date;

  @Column({ type: 'date', nullable: true })
  ExpectedDeliveryDate: Date;

  @Column({ type: 'varchar', length: 50 })
  Status: string;

  @Column({ type: 'varchar', length: 50 })
  Type: string;

  @OneToMany(() => MaterialStock, (materialStock) => materialStock.restockOrder)
  @JoinColumn({ name: 'MaterialStockId' })
  materialStocks: MaterialStock[];
}
