import {
  Controller,
  Get,
  Post,
  Body,
  Patch,
  Param,
  Delete,
} from '@nestjs/common';
import { MaterialRestockOrderService } from './material_restock_order.service';
import { CreateMaterialRestockOrderDto } from './dto/create-material_restock_order.dto';
import { UpdateMaterialRestockOrderDto } from './dto/update-material_restock_order.dto';

@Controller('material-restock-order')
export class MaterialRestockOrderController {
  constructor(
    private readonly materialRestockOrderService: MaterialRestockOrderService,
  ) {}

  @Post()
  create(@Body() createMaterialRestockOrderDto: CreateMaterialRestockOrderDto) {
    return this.materialRestockOrderService.create(
      createMaterialRestockOrderDto,
    );
  }

  @Get()
  findAll() {
    return this.materialRestockOrderService.findAll();
  }

  @Get(':id')
  findOne(@Param('id') id: string) {
    return this.materialRestockOrderService.findOne(+id);
  }

  @Patch(':id')
  update(
    @Param('id') id: string,
    @Body() updateMaterialRestockOrderDto: UpdateMaterialRestockOrderDto,
  ) {
    return this.materialRestockOrderService.update(
      +id,
      updateMaterialRestockOrderDto,
    );
  }

  @Delete(':id')
  remove(@Param('id') id: string) {
    return this.materialRestockOrderService.remove(+id);
  }
}
