import {
  Entity,
  ManyToOne,
  Column,
  JoinColumn,
  PrimaryGeneratedColumn,
} from 'typeorm';
import { Material } from '@/materials/entities/material.entity';
import { MaterialRestockOrder } from '@/material_restock_order/entities/material_restock_order.entity';

@Entity('Material_Stock')
export class MaterialStock {
  @PrimaryGeneratedColumn()
  MaterialID: number;

  @Column({ type: 'int' })
  QuantityOrdered: number;

  @Column({ type: 'int', default: 0 })
  QuantityReceived: number;

  @Column({ type: 'varchar', length: 50 })
  Status: string;

  @ManyToOne(() => Material, (material) => material.materialStocks)
  material: Material;

  @ManyToOne(
    () => MaterialRestockOrder,
    (restockOrder) => restockOrder.materialStocks,
  )
  @JoinColumn({ name: 'MaterialRestockOrderID' })
  restockOrder: MaterialRestockOrder;
}
