import {
  Controller,
  Get,
  Post,
  Body,
  Patch,
  Param,
  Delete,
} from '@nestjs/common';
import { MaterialStocksService } from './material_stocks.service';
import { CreateMaterialStockDto } from './dto/create-material_stock.dto';
import { UpdateMaterialStockDto } from './dto/update-material_stock.dto';

@Controller('material-stocks')
export class MaterialStocksController {
  constructor(private readonly materialStocksService: MaterialStocksService) {}

  @Post()
  create(@Body() createMaterialStockDto: CreateMaterialStockDto) {
    return this.materialStocksService.create(createMaterialStockDto);
  }

  @Get()
  findAll() {
    return this.materialStocksService.findAll();
  }

  @Get(':id')
  findOne(@Param('id') id: string) {
    return this.materialStocksService.findOne(+id);
  }

  @Patch(':id')
  update(
    @Param('id') id: string,
    @Body() updateMaterialStockDto: UpdateMaterialStockDto,
  ) {
    return this.materialStocksService.update(+id, updateMaterialStockDto);
  }

  @Delete(':id')
  remove(@Param('id') id: string) {
    return this.materialStocksService.remove(+id);
  }
}
