import {
  Entity,
  PrimaryGeneratedColumn,
  Column,
  OneToMany,
  UpdateDateColumn,
} from 'typeorm';
import { MaterialStock } from '@/material_stocks/entities/material_stock.entity';
import { RecipeIngredient } from '@/recipe_ingredients/entities/recipe_ingredient.entity';

@Entity('Material')
export class Material {
  @PrimaryGeneratedColumn()
  MaterialID: number;

  @Column({ type: 'varchar', length: 255 })
  name: string;

  @Column({ type: 'text', nullable: true })
  description: string;

  @Column({ type: 'int', default: 0 })
  QuantityInStock: number;

  @Column({ type: 'int', default: 0 })
  ReorderLevel: number;

  @Column({ type: 'varchar', length: 50 })
  unit: string;

  @Column({ type: 'decimal', precision: 10, scale: 2 })
  pricePerUnit: number;

  @UpdateDateColumn()
  LastUpdate: Date;

  @OneToMany(() => MaterialStock, (materialStock) => materialStock.material)
  materialStocks: MaterialStock[];

  @OneToMany(
    () => RecipeIngredient,
    (recipeIngredient) => recipeIngredient.material,
  )
  recipeIngredients: RecipeIngredient[]; // ✅ เชื่อมกับสูตรการผลิตที่ใช้วัตถุดิบนี้
}
