import { Module } from '@nestjs/common';
import { TypeOrmModule } from '@nestjs/typeorm';
import { MaterialsService } from './materials.service';
import { MaterialsController } from './materials.controller';
import { Material } from './entities/material.entity';
import { MaterialStock } from '@/material_stocks/entities/material_stock.entity';

@Module({
  imports: [TypeOrmModule.forFeature([Material, MaterialStock])], // ✅ Import TypeORM สำหรับ Material และ MaterialStock
  controllers: [MaterialsController],
  providers: [MaterialsService],
  exports: [MaterialsService], // ✅ Export service เพื่อให้ module อื่นเรียกใช้ได้
})
export class MaterialsModule {}
