import requests
import sys

# ✅ ตั้งค่าให้ Python รองรับ UTF-8 (แก้ปัญหาภาษาไทยใน CMD)
sys.stdout.reconfigure(encoding='utf-8')
# API endpoint
url = "http://localhost:4000/materials"

# Request data from API
try:
    response = requests.get(url)
    response.raise_for_status()  # Raise error for bad response (4xx, 5xx)
    materials = response.json()

    # Generate status report for each material
    report = []
    for material in materials:
        status = "เพียงพอ" if material["QuantityInStock"] > material["ReorderLevel"] else "ต้องสั่งเพิ่ม"
        report.append(f"Material: {material['name']} ({material['description']}) | คงเหลือ: {material['QuantityInStock']} {material['unit']} | สถานะ: {status}")

    # Show report
    report_text = "\n".join(report)
    print(report_text)

except requests.exceptions.RequestException as e:
    print(f"Error fetching data: {e}")
