import { Order } from '@/orders/entities/order.entity';
import {
  Entity,
  PrimaryGeneratedColumn,
  Column,
  ManyToOne,
  JoinColumn,
} from 'typeorm';

@Entity('Order_Detail')
export class OrderDetail {
  @PrimaryGeneratedColumn()
  OrderDetailID: number;

  @ManyToOne(() => Order, (order) => order.orderDetails, { eager: true })
  @JoinColumn({ name: 'OrderID' }) // กำหนดให้ OrderID เป็น FK
  order: Order;

  @Column({ type: 'varchar', length: 255 })
  Productname: string;

  @Column({ type: 'varchar', length: 255 })
  size: string;

  @Column({ type: 'varchar', length: 255 })
  waterBrand: string;

  @Column({ type: 'varchar', length: 255 })
  status: string;

  @Column({ type: 'int' })
  pricePerUnit: number;

  @Column({ type: 'int' })
  totalPrice: number;

  @Column({ type: 'int' })
  quantity: number;
}
