import {
  Entity,
  PrimaryGeneratedColumn,
  Column,
  ManyToOne,
  JoinColumn,
} from 'typeorm';
import { Order } from '@/orders/entities/order.entity';
import { Page } from '@/pages/entities/page.entity';

@Entity('OrderPriority')
export class OrderPriority {
  @PrimaryGeneratedColumn()
  orderPriorityID: number;

  @ManyToOne(() => Order, (order) => order.orderPriorities, {
    onDelete: 'CASCADE',
  })
  @JoinColumn({ name: 'OrderID' }) // ✅ Defines the foreign key for Order
  order: Order;

  @ManyToOne(() => Page, (page) => page.orderPriorities, {
    onDelete: 'CASCADE',
  })
  @JoinColumn({ name: 'PageID' }) // ✅ Defines the foreign key for Page
  page: Page;

  @Column({ name: 'Priority', type: 'int' })
  priority: number;
}
