import {
  Controller,
  Get,
  Post,
  Body,
  Patch,
  Param,
  Delete,
} from '@nestjs/common';
import { OrderpioritiesService } from './orderpiorities.service';
import { CreateOrderpiorityDto } from './dto/create-orderpiority.dto';
import { UpdateOrderpiorityDto } from './dto/update-orderpiority.dto';

@Controller('orderpiorities')
export class OrderpioritiesController {
  constructor(private readonly orderpioritiesService: OrderpioritiesService) {}

  @Post()
  create(@Body() createOrderpiorityDto: CreateOrderpiorityDto) {
    return this.orderpioritiesService.create(createOrderpiorityDto);
  }

  @Get()
  findAll() {
    return this.orderpioritiesService.findAll();
  }

  @Get(':id')
  findOne(@Param('id') id: string) {
    return this.orderpioritiesService.findOne(+id);
  }

  @Patch(':id')
  update(
    @Param('id') id: string,
    @Body() updateOrderpiorityDto: UpdateOrderpiorityDto,
  ) {
    return this.orderpioritiesService.update(+id, updateOrderpiorityDto);
  }

  @Delete(':id')
  remove(@Param('id') id: string) {
    return this.orderpioritiesService.remove(+id);
  }
}
