import { OrderDetail } from '@/order_details/entities/order_detail.entity';
import {
  Entity,
  PrimaryGeneratedColumn,
  Column,
  OneToMany,
  ManyToOne,
  JoinColumn,
} from 'typeorm';
import { Customer } from '@/customers/entities/customer.entity';
import { Queue } from '@/queues/entities/queue.entity';
import { OrderPriority } from '@/orderpiorities/entities/orderpiority.entity';
@Entity('Order')
export class Order {
  @PrimaryGeneratedColumn()
  OrderID: number;

  @ManyToOne(() => Customer, (customer) => customer.orders, {
    onDelete: 'CASCADE',
  })
  @JoinColumn({ name: 'CustomerID' })
  customer: Customer;

  @OneToMany(() => OrderPriority, (orderPriority) => orderPriority.order)
  orderPriorities: OrderPriority[]; // ✅ Added relationship to OrderPriority

  @OneToMany(() => OrderDetail, (orderDetail) => orderDetail.order, {
    cascade: true,
  })
  orderDetails: OrderDetail[];

  @OneToMany(() => Queue, (queue) => queue.order)
  queues: Queue[];

  @Column({ type: 'timestamp', default: () => 'CURRENT_TIMESTAMP' })
  OrderDate: Date;

  @Column({ type: 'varchar', length: 255 })
  status: string;

  @Column({ type: 'int' })
  totalPriceall: number;

  @Column({ type: 'int' })
  quantity: number;

  @Column({ type: 'timestamp', nullable: true })
  startDate: Date;

  @Column({ type: 'timestamp', nullable: true })
  finishDate: Date;
}
