import { Entity, PrimaryGeneratedColumn, Column, OneToMany } from 'typeorm';
import { Queue } from '@/queues/entities/queue.entity';
import { OrderPriority } from '@/orderpiorities/entities/orderpiority.entity';
@Entity('Page')
export class Page {
  @PrimaryGeneratedColumn()
  PageID: number;

  @Column({ type: 'timestamp', default: () => 'CURRENT_TIMESTAMP' })
  createdAt: Date;

  @Column({ type: 'timestamp', nullable: true, onUpdate: 'CURRENT_TIMESTAMP' })
  updatedAt: Date;

  @OneToMany(() => Queue, (queue) => queue.page)
  queues: Queue[];

  @OneToMany(() => OrderPriority, (orderPriority) => orderPriority.page)
  orderPriorities: OrderPriority[]; // ✅ Added relationship to OrderPriority
}
