import { Injectable } from '@nestjs/common';
import { InjectRepository } from '@nestjs/typeorm';
import { Repository } from 'typeorm';
import { Page } from './entities/page.entity';
import { CreatePageDto } from './dto/create-page.dto';
import { UpdatePageDto } from './dto/update-page.dto';

@Injectable()
export class PagesService {
  constructor(
    @InjectRepository(Page)
    private readonly pageRepository: Repository<Page>,
  ) {}

  async create(createPageDto: CreatePageDto) {
    const page = this.pageRepository.create(createPageDto);
    return await this.pageRepository.save(page);
  }

  async findAll() {
    return await this.pageRepository.find();
  }

  async findOne(id: number) {
    return await this.pageRepository.findOne({ where: { PageID: id } });
  }

  async update(id: number, updatePageDto: UpdatePageDto) {
    await this.pageRepository.update(id, updatePageDto);
    return await this.findOne(id);
  }

  async remove(id: number) {
    return await this.pageRepository.delete(id);
  }
}
