import {
  Entity,
  PrimaryGeneratedColumn,
  Column,
  ManyToOne,
  JoinColumn,
} from 'typeorm';
import { Product } from '@/products/entities/product.entity';

@Entity('Product_Stock')
export class ProductStock {
  @PrimaryGeneratedColumn()
  productStockID: number;

  @ManyToOne(() => Product, (product) => product.productStocks, {
    onDelete: 'CASCADE',
  })
  @JoinColumn({ name: 'ProductID' }) // ✅ เชื่อมกับ Product
  product: Product;

  @Column({ type: 'int' })
  quantityReceived: number;

  @Column({ type: 'varchar', length: 50 })
  status: string;

  @Column({ type: 'date' })
  addDate: Date;
}
