import { ProductStock } from '@/product_stocks/entities/product_stock.entity';
import { Entity, PrimaryGeneratedColumn, Column, OneToMany } from 'typeorm';

@Entity('Product')
export class Product {
  @PrimaryGeneratedColumn()
  ProductID: number;

  @Column()
  waterBrand: string;

  @Column()
  size: string;

  @Column()
  unit: string;

  @Column({ type: 'int', default: 0 })
  quantityInStock: number;

  @Column({ type: 'decimal', precision: 10, scale: 8 })
  pricePerUnit: number;

  @OneToMany(() => ProductStock, (productStock) => productStock.product)
  productStocks: ProductStock[];
}
