import {
  IsNotEmpty,
  IsNumber,
  IsISO8601,
  IsEnum,
  IsArray,
} from 'class-validator';

export class CreateQueueDto {
  @IsISO8601()
  @IsNotEmpty()
  startTime: string;

  @IsISO8601()
  @IsNotEmpty()
  finishTime: string;

  @IsEnum(['Pending', 'In Progress', 'Done'])
  @IsNotEmpty()
  status: string;

  @IsNotEmpty()
  bottleSize: string;

  @IsNumber()
  @IsNotEmpty()
  MachineID: number;

  @IsNumber()
  @IsNotEmpty()
  PageID: number;

  @IsNumber()
  @IsNotEmpty()
  OrderID: number;

  @IsArray()
  @IsNumber({}, { each: true })
  @IsNotEmpty()
  EmployeeIds: number[]; // ✅ เปลี่ยนเป็น employeeIds
}
