import {
  Entity,
  PrimaryGeneratedColumn,
  Column,
  ManyToOne,
  ManyToMany,
  JoinTable,
  JoinColumn,
} from 'typeorm';
import { Machine } from '@/machines/entities/machine.entity';
import { Order } from '@/orders/entities/order.entity';
import { Employee } from '@/employees/entities/employee.entity';
import { Page } from '@/pages/entities/page.entity';

@Entity('Queue')
export class Queue {
  @PrimaryGeneratedColumn()
  QueueID: number;

  @ManyToOne(() => Machine, (machine) => machine.queues, {
    onDelete: 'CASCADE',
  })
  @JoinColumn({ name: 'MachineId' })
  machine: Machine;

  @ManyToOne(() => Page, (page) => page.queues, { onDelete: 'CASCADE' })
  @JoinColumn({ name: 'PageID' })
  page: Page;

  @ManyToOne(() => Order, (order) => order.queues, { onDelete: 'CASCADE' })
  @JoinColumn({ name: 'OrderID' })
  order: Order;

  @ManyToMany(() => Employee, (employee) => employee.queues)
  @JoinTable({
    name: 'QueueAssignment', // Custom table name
    joinColumn: { name: 'QueueID', referencedColumnName: 'QueueID' },
    inverseJoinColumn: {
      name: 'EmployeeID',
      referencedColumnName: 'EmployeeID',
    },
  })
  employees: Employee[];

  @Column({ type: 'timestamp', nullable: true })
  startTime: Date;

  @Column({ type: 'timestamp', nullable: true })
  finishTime: Date;

  @Column({ type: 'varchar', length: 50 })
  status: string;

  @Column({ type: 'varchar', length: 50 })
  bottleSize: string;

  @Column()
  producedQuantity: number;
}
