import {
  Entity,
  PrimaryGeneratedColumn,
  Column,
  ManyToOne,
  JoinColumn,
} from 'typeorm';
import { Recipe } from '@/recipes/entities/recipe.entity';
import { Material } from '@/materials/entities/material.entity';

@Entity('Recipe_Ingredient')
export class RecipeIngredient {
  @PrimaryGeneratedColumn({ name: 'RecipeIngredientID' })
  recipeIngredientID: number;

  @ManyToOne(() => Recipe, (recipe) => recipe.ingredients, {
    onDelete: 'CASCADE',
  })
  @JoinColumn({ name: 'RecipeID' }) // ✅ กำหนดชื่อ Foreign Key ให้ตรง ERD
  recipe: Recipe;

  @ManyToOne(() => Material, (material) => material.MaterialID, {
    onDelete: 'CASCADE',
  })
  @JoinColumn({ name: 'MaterialID' }) // ✅ กำหนดชื่อ Foreign Key ให้ตรง ERD
  material: Material;

  @Column({ name: 'QuantityNeed', type: 'decimal', precision: 10, scale: 6 })
  quantityNeed: number; // จำนวนวัตถุดิบที่ต้องใช้ต่อ 1 รอบ
}
