import {
  Entity,
  PrimaryGeneratedColumn,
  Column,
  ManyToOne,
  JoinColumn,
  OneToMany,
} from 'typeorm';
import { MachineDetail } from '@/machine_details/entities/machine_detail.entity';
import { RecipeIngredient } from '@/recipe_ingredients/entities/recipe_ingredient.entity';
@Entity('Recipe')
export class Recipe {
  @PrimaryGeneratedColumn({ name: 'RecipeID' })
  recipeID: number;

  @OneToMany(
    () => RecipeIngredient,
    (recipeIngredient) => recipeIngredient.recipe,
  )
  ingredients: RecipeIngredient[]; // ✅ เชื่อมไปยังวัตถุดิบที่ต้องใช้

  @ManyToOne(() => MachineDetail, (machineDetail) => machineDetail.recipes, {
    onDelete: 'CASCADE',
  })
  @JoinColumn({ name: 'MachineDetailID' }) // ✅ กำหนดชื่อคอลัมน์ให้ตรงกับ ERD
  machineDetail: MachineDetail;

  @Column({ name: 'OutputItemID', type: 'int' })
  outputItemID: number; // อ้างถึง ProductID หรือ MaterialID

  @Column({
    name: 'OutputItemType',
    type: 'enum',
    enum: ['PRODUCT', 'MATERIAL'],
  })
  outputItemType: 'PRODUCT' | 'MATERIAL';

  @Column({ name: 'OutputQuantity', type: 'int' })
  outputQuantity: number;
}
