import { Entity, PrimaryGeneratedColumn, Column } from 'typeorm';

@Entity('Stock_Config')
export class StockConfig {
  @PrimaryGeneratedColumn()
  stockConfigID: number;

  @Column({ name: 'ItemID', type: 'int' }) // ✅ เก็บ ID ของ Product หรือ Material
  itemID: number;

  @Column({ name: 'ItemType', type: 'enum', enum: ['PRODUCT', 'MATERIAL'] }) // ✅ ระบุประเภท
  itemType: 'PRODUCT' | 'MATERIAL';

  @Column({ type: 'int' })
  targetStockLevel: number; // ✅ ปริมาณที่ต้องการเก็บเพื่อให้ปลอดภัย

  @Column({ type: 'timestamp', default: () => 'CURRENT_TIMESTAMP' })
  lastUpdated: Date;
}
