import { Controller, Get, Post, Body, Patch, Param, Delete } from '@nestjs/common';
import { StockConfigsService } from './stock_configs.service';
import { CreateStockConfigDto } from './dto/create-stock_config.dto';
import { UpdateStockConfigDto } from './dto/update-stock_config.dto';

@Controller('stock-configs')
export class StockConfigsController {
  constructor(private readonly stockConfigsService: StockConfigsService) {}

  @Post()
  create(@Body() createStockConfigDto: CreateStockConfigDto) {
    return this.stockConfigsService.create(createStockConfigDto);
  }

  @Get()
  findAll() {
    return this.stockConfigsService.findAll();
  }

  @Get(':id')
  findOne(@Param('id') id: string) {
    return this.stockConfigsService.findOne(+id);
  }

  @Patch(':id')
  update(@Param('id') id: string, @Body() updateStockConfigDto: UpdateStockConfigDto) {
    return this.stockConfigsService.update(+id, updateStockConfigDto);
  }

  @Delete(':id')
  remove(@Param('id') id: string) {
    return this.stockConfigsService.remove(+id);
  }
}
