import type { Page } from "../types/Page";

export class PageService {
  private pages: Page[] = [];

  // ดึงข้อมูลหน้าทั้งหมด
  getPages(): Page[] {
    return this.pages;
  }

  // ค้นหาหน้าโดยใช้ pageID
  getPageById(pageID: number): Page | undefined {
    return this.pages.find(page => page.pageID === pageID);
  }

  // เพิ่มหน้าใหม่
  addPage(page: Page): void {
    this.pages.push(page);
  }

  // อัปเดตข้อมูลของหน้า
  updatePage(updatedPage: Page): void {
    const index = this.pages.findIndex(page => page.pageID === updatedPage.pageID);
    if (index !== -1) {
      this.pages[index] = updatedPage;
    }
  }

  // ลบหน้าตาม pageID
  removePage(pageID: number): void {
    this.pages = this.pages.filter(page => page.pageID !== pageID);
  }
}
