import type { Queue } from '@/types/Queue'

export class QueueService {
  private queue: Queue[] = [];

  // ดึงรายการคิวทั้งหมด
  getQueue(): Queue[] {
    return this.queue;
  }

  // ค้นหารายการคิวโดยใช้ queueID
  getQueueById(queueID: number): Queue | undefined {
    return this.queue.find(item => item.queueID === queueID);
  }

  // เพิ่มรายการใหม่เข้า queue
  addQueueItem(item: Queue): void {
    this.queue.push(item);
  }

  // อัปเดตรายการ queue ที่มีอยู่
  updateQueueItem(updatedItem: Queue): void {
    const index = this.queue.findIndex(item => item.queueID === updatedItem.queueID);
    if (index !== -1) {
      this.queue[index] = updatedItem;
    }
  }

  // ลบรายการ queue ตาม queueID
  removeQueueItem(queueID: number): void {
    this.queue = this.queue.filter(item => item.queueID !== queueID);
  }

  // เปลี่ยนสถานะของคิว
  updateQueueStatus(queueID: number, status: 'pending' | 'in-progress' | 'completed' | 'canceled'): void {
    const queueItem = this.getQueueById(queueID);
    if (queueItem) {
      queueItem.status = status;
    }
  }

  // คำนวณเวลาการทำงานของ queue
  calculateProductionTime(queueID: number): number | null {
    const queueItem = this.getQueueById(queueID);
    if (queueItem && queueItem.startTime && queueItem.finishTime) {
      return (queueItem.finishTime.getTime() - queueItem.startTime.getTime()) / (1000 * 60); // แปลงเป็นนาที
    }
    return null;
  }
}
