import type { User } from '@/types/User'
import http from './http'

function addUser(user: User & { files?: File[] }) {
  const formData = new FormData()
  formData.append('email', user.email)
  formData.append('name', user.name)
  if (user.gender) formData.append('gender', user.gender)
  if (user.password) formData.append('password', user.password)
  if (user.role?.id) formData.append('roleId', user.role.id.toString()) // ✅ ใช้ roleId แทน JSON

  if (user.files && user.files.length > 0) {
    formData.append('file', user.files[0])
  }

  return http.post('/users', formData, {
    headers: { 'Content-Type': 'multipart/form-data' }
  })
}

function updateUser(user: User & { files?: File[] }) {
  if (user.files && user.files.length > 0) {
    const formData = new FormData()
    formData.append('email', user.email)
    formData.append('name', user.name)
    if (user.gender) formData.append('gender', user.gender)
    if (user.password) formData.append('password', user.password)
    if (user.role?.id) formData.append('roleId', user.role.id.toString())

    formData.append('file', user.files[0])

    return http.put(`/users/${user.id}`, formData, {
      headers: { 'Content-Type': 'multipart/form-data' }
    })
  } else {
    const payload = {
      email: user.email,
      name: user.name,
      gender: user.gender || null,
      password: user.password || null,
      roleId: user.role?.id || null
    }

    return http.put(`/users/${user.id}`, payload)
  }
}

function delUser(userId: number) {
  return http.delete(`/users/${userId}`)
}

function getUser(id: number) {
  return http.get(`/users/${id}`)
}

function getUsers() {
  return http.get('/users')
}

export default { addUser, updateUser, delUser, getUser, getUsers }
