import { defineStore } from 'pinia'
import type { User } from '@/types/User'
import authService from '@/services/auth'
import { useMessageStore } from '@/stores/message'
import { useRouter } from 'vue-router'
import { useLoadingStore } from './loading'
import { useUserStore } from './user'

export const useAuthStore = defineStore('auth', () => {
  const messageStore = useMessageStore()
  const router = useRouter()
  const loadingStore = useLoadingStore()
  const userStore = useUserStore()

  async function login(email: string, password: string) {
    loadingStore.doLoad()
    try {
      const res = await authService.login(email, password)
      console.log(res.data)

      localStorage.setItem('user', JSON.stringify(res.data.user))
      localStorage.setItem('access_token', res.data.access_token)

      userStore.currentUser = res.data.user
      router.replace('/pq-view')
    } catch (e: any) {
      console.log(e)
      messageStore.showMessage(e.message)
    }
    loadingStore.finish()
  }

  function logout() {
    localStorage.removeItem('user')
    localStorage.removeItem('access_token')
    userStore.currentUser = null
    router.replace('/login')
  }

  function getCurrentUser(): User | null {
    const strUser = localStorage.getItem('user')
    if (strUser === null) return null
    return JSON.parse(strUser)
  }

  function getToken(): string | null {
    return localStorage.getItem('access_token')
  }

  return { getCurrentUser, getToken, login, logout }
})
