import type { Role } from './Role'

type Gender = 'male' | 'female' | 'others'

type User = {
  id?: number
  email: string
  password?: string // ทำให้เป็น optional
  name: string
  image?: string // ทำให้ optional และตั้งค่าเริ่มต้นที่ backend เป็น "noimage.jpg"
  gender?: Gender // ไม่ใช่ทุก user ที่ต้องกำหนดเพศ
  role?: Role // บางกรณี user อาจยังไม่มี role
}

export type { Gender, User }
