require('dotenv').config(); //โหลดตัวแปร .env ก่อน
const express = require('express');
const router = express.Router();
const pool = require('../config/database'); //Import database หลังจากโหลด .env
const isLoggedIn = (req, res, next) => {
    if (req.session.userId) {
        next(); // ผู้ใช้ Login แล้ว
    } else {
        res.redirect('/login'); // ยังไม่ Login
    }
};

console.log("Database Host:", process.env.DB_HOST);

router.get('/', async (req, res) => {
    try {
        const [products] = await pool.query('SELECT * FROM products WHERE stock > 0');
        res.render('index', { products });
    } catch (error) {
        console.error(error);
        res.status(500).send('Error fetching products');
    }
});

module.exports = router;