const express = require('express');
const router = express.Router();
const pool = require('../config/database');
const bcrypt = require('bcrypt'); // ใช้สำหรับ Hash รหัสผ่าน
const session = require('express-session');


// ฟังก์ชันตรวจสอบผู้ใช้จาก Database
async function checkUser(email, password) {
    const [rows] = await pool.query('SELECT * FROM users WHERE email = ?', [email]);
    if (rows.length > 0) {
        const user = rows[0];
        const match = await bcrypt.compare(password, user.password); // ตรวจสอบรหัสผ่าน
        return match ? user : null;
    }
    return null;
}

// Route สำหรับแสดงหน้า Login (GET)
router.get('/login', (req, res) => {
    res.render('login'); // ต้องมีไฟล์ login.ejs ในโฟลเดอร์ views
});

// Route สำหรับ Login (POST)
router.post('/login', async (req, res) => {
    const { email, password } = req.body;
    const user = await checkUser(email, password);

    if (user) {
        req.session.user = { id: user.id, email: user.email };
        console.log("Session after login:", req.session);
        res.redirect('/order/checkout'); // หรือ '/auth/order/checkout' ขึ้นอยู่กับ Route
    } else {
        res.send('Invalid email or password');
    }
});

router.get('/register', (req,res) => {
    res.render('register');
});

// Route สำหรับ Logout
router.get('/logout', (req, res) => {
    req.session.destroy(() => {
        res.redirect('/login');
    });
});

module.exports = router;