const mysql = require('mysql2/promise');
require('dotenv').config();

const pool = mysql.createPool({
    host: process.env.DB_HOST || 'localhost',
    user: process.env.DB_USER || 'root',
    password: process.env.DB_PASSWORD || '',
    database: process.env.DB_NAME || 'myshop',
    waitForConnections: true,
    connectionLimit: 10,
    queueLimit: 0
});

// ทดสอบการเชื่อมต่อ
(async () => {
    try {
        const connection = await pool.getConnection();
        console.log("Connected to MySQL database.");
        connection.release(); // ปล่อย connection กลับไปที่ pool
    } catch (err) {
        console.error("Database connection failed:", err.message);
    }
})();

module.exports = pool;